<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    //
    public function index(){

        if(check_roles('service_access')){

            try {


                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function add(Request $request){
        if(check_roles('service_add')){

            try {


                $success = true;
                $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }
    }

    public function edit($id){
        if(check_roles('service_access')){

            try {


                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function update($id, Request $request){
        if(check_roles('service_update')){

            try {


                $success = true;
                $message = 'ອັບເດດຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function delete($id){
        if(check_roles('service_remove')){

            try {


                $success = true;
                $message = 'ລຶບຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }
}
